/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.gantry;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.AssemblyException;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionCollider;
import com.simibubi.create.content.contraptions.components.structureMovement.IDisplayAssemblyExceptions;
import com.simibubi.create.content.contraptions.components.structureMovement.gantry.GantryCarriageBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.gantry.GantryContraption;
import com.simibubi.create.content.contraptions.components.structureMovement.gantry.GantryContraptionEntity;
import com.simibubi.create.content.contraptions.relays.advanced.GantryShaftBlock;
import com.simibubi.create.content.contraptions.relays.advanced.GantryShaftTileEntity;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_4538;

public class GantryCarriageTileEntity
extends KineticTileEntity
implements IDisplayAssemblyExceptions {
    boolean assembleNextTick;
    protected AssemblyException lastException;

    public GantryCarriageTileEntity(class_2591<?> typeIn, class_2338 pos, class_2680 state) {
        super(typeIn, pos, state);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.registerAwardables(behaviours, AllAdvancements.CONTRAPTION_ACTORS);
    }

    @Override
    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
    }

    public void checkValidGantryShaft() {
        if (this.shouldAssemble()) {
            this.queueAssembly();
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!this.method_11010().method_26184((class_4538)this.field_11863, this.field_11867)) {
            this.field_11863.method_22352(this.field_11867, true);
        }
    }

    public void queueAssembly() {
        this.assembleNextTick = true;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.field_11863.field_9236) {
            return;
        }
        if (this.assembleNextTick) {
            this.tryAssemble();
            this.assembleNextTick = false;
        }
    }

    @Override
    public AssemblyException getLastAssemblyException() {
        return this.lastException;
    }

    private void tryAssemble() {
        class_2350 shaftOrientation;
        class_2680 blockState = this.method_11010();
        if (!(blockState.method_26204() instanceof GantryCarriageBlock)) {
            return;
        }
        class_2350 direction = (class_2350)blockState.method_11654((class_2769)GantryCarriageBlock.FACING);
        GantryContraption contraption = new GantryContraption(direction);
        class_2586 shaftTe = this.field_11863.method_8321(this.field_11867.method_10093(direction.method_10153()));
        if (!(shaftTe instanceof GantryShaftTileEntity)) {
            return;
        }
        class_2680 shaftState = shaftTe.method_11010();
        if (!AllBlocks.GANTRY_SHAFT.has(shaftState)) {
            return;
        }
        float pinionMovementSpeed = ((GantryShaftTileEntity)shaftTe).getPinionMovementSpeed();
        class_2350 movementDirection = shaftOrientation = (class_2350)shaftState.method_11654((class_2769)GantryShaftBlock.FACING);
        if (pinionMovementSpeed < 0.0f) {
            movementDirection = movementDirection.method_10153();
        }
        try {
            this.lastException = null;
            if (!contraption.assemble(this.field_11863, this.field_11867)) {
                return;
            }
            this.sendData();
        }
        catch (AssemblyException e) {
            this.lastException = e;
            this.sendData();
            return;
        }
        if (ContraptionCollider.isCollidingWithWorld(this.field_11863, contraption, this.field_11867.method_10093(movementDirection), movementDirection)) {
            return;
        }
        if (contraption.containsBlockBreakers()) {
            this.award(AllAdvancements.CONTRAPTION_ACTORS);
        }
        contraption.removeBlocksFromWorld(this.field_11863, class_2338.field_10980);
        GantryContraptionEntity movedContraption = GantryContraptionEntity.create(this.field_11863, contraption, shaftOrientation);
        class_2338 anchor = this.field_11867;
        movedContraption.method_5814(anchor.method_10263(), anchor.method_10264(), anchor.method_10260());
        AllSoundEvents.CONTRAPTION_ASSEMBLE.playOnServer(this.field_11863, (class_2382)this.field_11867);
        this.field_11863.method_8649((class_1297)movedContraption);
    }

    @Override
    protected void write(class_2487 compound, boolean clientPacket) {
        AssemblyException.write(compound, this.lastException);
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        this.lastException = AssemblyException.read(compound);
        super.read(compound, clientPacket);
    }

    @Override
    public float propagateRotationTo(KineticTileEntity target, class_2680 stateFrom, class_2680 stateTo, class_2338 diff, boolean connectedViaAxes, boolean connectedViaCogs) {
        float defaultModifier = super.propagateRotationTo(target, stateFrom, stateTo, diff, connectedViaAxes, connectedViaCogs);
        if (connectedViaAxes) {
            return defaultModifier;
        }
        if (!AllBlocks.GANTRY_SHAFT.has(stateTo)) {
            return defaultModifier;
        }
        if (!((Boolean)stateTo.method_11654((class_2769)GantryShaftBlock.POWERED)).booleanValue()) {
            return defaultModifier;
        }
        class_2350 direction = class_2350.method_10147((float)diff.method_10263(), (float)diff.method_10264(), (float)diff.method_10260());
        if (stateFrom.method_11654((class_2769)GantryCarriageBlock.FACING) != direction.method_10153()) {
            return defaultModifier;
        }
        return GantryCarriageTileEntity.getGantryPinionModifier((class_2350)stateTo.method_11654((class_2769)GantryShaftBlock.FACING), (class_2350)stateFrom.method_11654((class_2769)GantryCarriageBlock.FACING));
    }

    public static float getGantryPinionModifier(class_2350 shaft, class_2350 pinionDirection) {
        class_2350.class_2351 shaftAxis = shaft.method_10166();
        float directionModifier = shaft.method_10171().method_10181();
        if (shaftAxis == class_2350.class_2351.field_11052 && (pinionDirection == class_2350.field_11043 || pinionDirection == class_2350.field_11034)) {
            return -directionModifier;
        }
        if (shaftAxis == class_2350.class_2351.field_11048 && (pinionDirection == class_2350.field_11033 || pinionDirection == class_2350.field_11035)) {
            return -directionModifier;
        }
        if (shaftAxis == class_2350.class_2351.field_11051 && (pinionDirection == class_2350.field_11036 || pinionDirection == class_2350.field_11039)) {
            return -directionModifier;
        }
        return directionModifier;
    }

    private boolean shouldAssemble() {
        class_2680 blockState = this.method_11010();
        if (!(blockState.method_26204() instanceof GantryCarriageBlock)) {
            return false;
        }
        class_2350 facing = ((class_2350)blockState.method_11654((class_2769)GantryCarriageBlock.FACING)).method_10153();
        class_2680 shaftState = this.field_11863.method_8320(this.field_11867.method_10093(facing));
        if (!(shaftState.method_26204() instanceof GantryShaftBlock)) {
            return false;
        }
        if (((Boolean)shaftState.method_11654((class_2769)GantryShaftBlock.POWERED)).booleanValue()) {
            return false;
        }
        class_2586 te = this.field_11863.method_8321(this.field_11867.method_10093(facing));
        return te instanceof GantryShaftTileEntity && ((GantryShaftTileEntity)te).canAssembleOn();
    }
}

